package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.PlanEquipmentPurchase;
import cn.wise.sc.cement.business.entity.SysRole;
import cn.wise.sc.cement.business.entity.Team;
import cn.wise.sc.cement.business.mapper.PlanEquipmentPurchaseMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.query.RoleQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import cn.wise.sc.cement.business.model.vo.PlanEquipmentPurchaseVo;
import cn.wise.sc.cement.business.model.vo.TeamListVo;
import cn.wise.sc.cement.business.model.vo.TeamVo;
import cn.wise.sc.cement.business.service.IPlanEquipmentPurchaseService;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Service
public class PlanEquipmentPurchaseServiceImpl extends ServiceImpl<PlanEquipmentPurchaseMapper, PlanEquipmentPurchase> implements IPlanEquipmentPurchaseService {

	@Resource
	private PlanEquipmentPurchaseMapper equipmentPurchaseMapper;
	@Autowired
	private ISysUserService userService;

	/**
	 * 分页查询
	 *
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<PlanEquipmentPurchaseVo>> getPage(PageQuery pageQuery, String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		Page<PlanEquipmentPurchaseVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<PlanEquipmentPurchaseVo> pages = equipmentPurchaseMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 设备采购计划列表导出
	 *
	 * @param name
	 * @param fileName
	 * @param response
	 */
	@Override
	public void export(String name, String fileName, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		List<Map<String, Object>> list = equipmentPurchaseMapper.exportList(params);

		if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[map.size()];
			headers[0] = "序号";
			headers[1] = "产品名称";
			headers[2] = "规格/型号";
			headers[3] = "技术指标";
			headers[4] = "单价（万元）";
			headers[5] = "生产单位";
			headers[6] = "采购数量";
			headers[7] = "购买日期";
			headers[8] = "采购人";

			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]).toString();
					if (j == 0) {
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}
				datas.add(objects);
			}
			ExcelUtil.excelExport(
					fileName == null || fileName.trim().length() <= 0 ? "设备采购计划" : fileName, headers,
					datas, response);
		}
	}

	/**
	 * 创建
	 *
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanEquipmentPurchase> create(PlanEquipmentPurchaseQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if (loginUser == null) {
			return BaseResponse.errorMsg("请登录用户");
		}
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanEquipmentPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = equipmentPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanEquipmentPurchase pep = new PlanEquipmentPurchase();
		BeanUtils.copyProperties(query, pep);
		pep.setUserId(loginUser.getId())
				.setStatus(0)
				.setCreateTime(LocalDateTime.now());
		equipmentPurchaseMapper.insert(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 修改
	 *
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanEquipmentPurchase> update(PlanEquipmentPurchaseQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanEquipmentPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = equipmentPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanEquipmentPurchase pep = equipmentPurchaseMapper.selectById(query.getId());
		BeanUtils.copyProperties(query, pep);
		equipmentPurchaseMapper.updateById(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 获取详情
	 *
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<PlanEquipmentPurchaseVo> getDetail(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanEquipmentPurchase pep = equipmentPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("信息错误!");
		}
		PlanEquipmentPurchaseVo planEquipmentPurchaseVo = equipmentPurchaseMapper.getDetail(id);
		return BaseResponse.okData(planEquipmentPurchaseVo);
	}

	/**
	 * 采购完成
	 *
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> finish(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanEquipmentPurchase pep = equipmentPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		pep.setStatus(1); //采购完成
		equipmentPurchaseMapper.updateById(pep);
		return BaseResponse.okData("采购完成");
	}

	/**
	 * 删除
	 *
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<String> delete(Integer id) {
		PlanEquipmentPurchase pep = equipmentPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		equipmentPurchaseMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

}
