package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.HistoryArchives;
import cn.wise.sc.cement.business.entity.PlanPeople;
import cn.wise.sc.cement.business.entity.PlanTraining;
import cn.wise.sc.cement.business.entity.SampleDistribution;
import cn.wise.sc.cement.business.mapper.HistoryArchivesMapper;
import cn.wise.sc.cement.business.mapper.PlanPeopleMapper;
import cn.wise.sc.cement.business.mapper.PlanTrainingMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanPeopleQuery;
import cn.wise.sc.cement.business.model.vo.HistoryArchivesVo;
import cn.wise.sc.cement.business.model.vo.PlanPeopleVo;
import cn.wise.sc.cement.business.model.vo.PlanTrainingVo;
import cn.wise.sc.cement.business.service.IHistoryArchivesService;
import cn.wise.sc.cement.business.service.IPlanPeopleService;
import cn.wise.sc.cement.business.service.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-10-19
 */
@Service
public class PlanPeopleServiceImpl extends ServiceImpl<PlanPeopleMapper, PlanPeople> implements IPlanPeopleService {
	@Resource
	private PlanPeopleMapper planPeopleMapper;

	@Resource
	private PlanTrainingMapper planTrainingMapper;

	@Resource
	private HistoryArchivesMapper historyArchivesMapper;

	@Autowired
	private ISysUserService userService;

	@Autowired
	private IHistoryArchivesService iHistoryArchivesService;

	@Override
	public BaseResponse<IPage<PlanPeopleVo>> getPage(PageQuery pageQuery, Integer planId) {
		Map<String, Object> params = new HashMap<>();
		params.put("planId", planId);
		Page<PlanPeopleVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<PlanPeopleVo> pages = planPeopleMapper.getPage(page, params);
//		IPage<PlanPeople> iPage = new Page<>(pageQuery.getPageNo(),pageQuery.getPageSize());
//		IPage<PlanPeople> pages = this.page(iPage);
		return BaseResponse.okData(pages);
	}

	@Override
	public BaseResponse<List<PlanPeople>> getList() {
		QueryWrapper<PlanPeople> qw = new QueryWrapper<>();
		qw.ne("id", 0);
		List<PlanPeople> list = this.list(qw);
		return BaseResponse.okData(list);
	}

	@Override
	public BaseResponse<String> status(Integer status, Integer id) {
		if (status == null || id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanPeople planPeople = planPeopleMapper.selectById(id);
		if (planPeople == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		planPeople.setStatus(status);
		planPeopleMapper.updateById(planPeople);
		String result = "";
		if (planPeople.getStatus() == 1) {
			result = "通过";
		} else {
			result = "未通过";
		}
		return BaseResponse.okData(result);
	}

	@Override
	@Transactional
	public BaseResponse<PlanPeople> uploadPlanPF(PlanPeopleQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if (loginUser == null) {
			return BaseResponse.errorMsg("请登录账号");
		}
		if (query == null || query.getId() == null) {
			return BaseResponse.errorMsg("参数错误");
		}
		PlanPeople planPeople = planPeopleMapper.selectById(query.getId());
		if (planPeople == null) {
			return BaseResponse.errorMsg("数据错误");
		}
		planPeople.setEnclosureUrl(query.getEnclosureUrl())
				.setExtName(query.getExtName())
				.setAlias(query.getAlias())
				.setStatus(1);
		if (StringUtils.isEmpty(query.getEnclosureUrl())) {
			planPeople.setStatus(2);
		}
		planPeopleMapper.updateById(planPeople);
		return BaseResponse.okData(planPeople);
	}

	@Override
	public BaseResponse synchronization(Integer id) {
		PlanPeople planPeople = planPeopleMapper.selectById(id);
		if (planPeople!=null) {
			Integer planId = planPeople.getPlanId();
				PlanTraining planTraining = planTrainingMapper.selectById(planId);
				if (planTraining!=null){
				HistoryArchives historyArchives = new HistoryArchives();
				historyArchives.setCreateTime(LocalDateTime.now())
						.setTime(planTraining.getStartTime())
						.setType(planTraining.getContent())
						.setContent(planTraining.getObjective())
						.setUserId(planPeople.getUserId());

				historyArchivesMapper.insert(historyArchives);

				return BaseResponse.okData("同步成功");
			}
			else {
				return BaseResponse.errorMsg("该数据不存在，请重新输入正确的数据");
			}
		}
		else {
			return BaseResponse.errorMsg("该数据不存在，请输入正确的数据");
		}
	}
}
