package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.PlanConsumablesPurchase;
import cn.wise.sc.cement.business.entity.PlanStandardPurchase;
import cn.wise.sc.cement.business.mapper.PlanStandardPurchaseMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanConsumablesPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanStandardPurchaseQuery;
import cn.wise.sc.cement.business.model.vo.PlanConsumablesPurchaseVo;
import cn.wise.sc.cement.business.model.vo.PlanStandardPurchaseVo;
import cn.wise.sc.cement.business.service.IPlanStandardPurchaseService;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Service
public class PlanStandardPurchaseServiceImpl extends ServiceImpl<PlanStandardPurchaseMapper, PlanStandardPurchase> implements IPlanStandardPurchaseService {

	@Resource
	private PlanStandardPurchaseMapper standardPurchaseMapper;
	@Autowired
	private ISysUserService userService;

	/**
	 * 分页查询
	 *
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<PlanStandardPurchaseVo>> getPage(PageQuery pageQuery, String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		Page<PlanStandardPurchaseVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<PlanStandardPurchaseVo> pages = standardPurchaseMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 标样采购计划导出
	 *
	 * @param name
	 * @param fileName
	 * @param response
	 */
	@Override
	public void export(String name, String fileName, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		List<Map<String, Object>> list = standardPurchaseMapper.exportList(params);

		if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[map.size()];
			headers[0] = "序号";
			headers[1] = "标物名称";
			headers[2] = "经销单位";
			headers[3] = "采购数量";
			headers[4] = "采购时间";
			headers[5] = "采购人";

			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]).toString();
					if (j == 0) {
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}
				datas.add(objects);
			}
			ExcelUtil.excelExport(
					fileName == null || fileName.trim().length() <= 0 ? "标样采购计划" : fileName, headers,
					datas, response);
		}
	}

	/**
	 * 创建
	 *
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanStandardPurchase> create(PlanStandardPurchaseQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if (loginUser == null) {
			return BaseResponse.errorMsg("请登录用户");
		}
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanStandardPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = standardPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanStandardPurchase pep = new PlanStandardPurchase();
		BeanUtils.copyProperties(query, pep);
		pep.setUserId(loginUser.getId())
				.setStatus(0)
				.setCreateTime(LocalDateTime.now());
		standardPurchaseMapper.insert(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 修改
	 *
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanStandardPurchase> update(PlanStandardPurchaseQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanStandardPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = standardPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanStandardPurchase pep = standardPurchaseMapper.selectById(query.getId());
		BeanUtils.copyProperties(query, pep);
		standardPurchaseMapper.updateById(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 获取详情
	 *
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<PlanStandardPurchaseVo> getDetail(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanStandardPurchase pep = standardPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("信息错误!");
		}
		PlanStandardPurchaseVo planEquipmentPurchaseVo = standardPurchaseMapper.getDetail(id);
		return BaseResponse.okData(planEquipmentPurchaseVo);
	}

	/**
	 * 采购完成
	 *
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> finish(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanStandardPurchase pep = standardPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		pep.setStatus(1); //采购完成
		standardPurchaseMapper.updateById(pep);
		return BaseResponse.okData("采购完成");
	}

	/**
	 * 删除
	 *
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<String> delete(Integer id) {
		PlanStandardPurchase pep = standardPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("数据错误!");
		}
		standardPurchaseMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

}
