package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.Equipment;
import cn.wise.sc.cement.business.entity.SysPost;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.*;
import cn.wise.sc.cement.business.model.vo.TeamVo;
import cn.wise.sc.cement.business.service.IEquipmentService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Api(tags="资源管理-设备管理")
@RestController
@RequestMapping("/business/equipment")
public class EquipmentController {

	private static final Logger log = LoggerFactory.getLogger("EquipmentController");

	@Autowired
	private IEquipmentService equipmentService;


	@ApiOperation(value = "设备分页列表 (设备列表，设备检定列表)")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "brand", value = "设备品牌", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "supplierId", value = "供应商表id", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "name", value = "设备名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String brand, Integer supplierId, String name) {
		try {
			return equipmentService.getPage(pageQuery, brand, supplierId, name);
		} catch (Exception e) {
			log.debug("设备分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检定设备")
	@PostMapping("/test")
	public BaseResponse test(@RequestBody EquipmentTestQuery query) {
		try {
			return equipmentService.test(query);
		}catch (Exception e) {
			log.debug("检定设备{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备检定历史")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "equipmentId", value = "设备表id", paramType = "query", dataType = "Integer")
	})
	@GetMapping("/getTestPage")
	public BaseResponse getTestPage(PageQuery pageQuery, Integer equipmentId) {
		try {
			return equipmentService.getTestPage(pageQuery, equipmentId);
		} catch (Exception e) {
			log.debug("设备检定历史{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("设备列表导出")
	@PostMapping("/export")
	public void export(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response) {
		try {
			equipmentService.export(brand, supplierId, name, fileName, response);
		} catch (Exception e) {
			log.debug("设备列表导出{}", e);
		}
	}

	@ApiOperation("设备检定列表导出")
	@PostMapping("/exportTest")
	public void exportTest(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response) {
		try {
			equipmentService.exportTest(brand, supplierId, name, fileName, response);
		} catch (Exception e) {
			log.debug("设备检定列表导出{}", e);
		}
	}

	@ApiOperation(value = "新增设备")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody EquipmentQuery query) {
		try {
			return equipmentService.create(query);
		}catch (Exception e) {
			log.debug("新增设备{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改设备")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody EquipmentQuery query) {
		try {
			return equipmentService.update(query);
		}catch (Exception e) {
			log.debug("修改设备{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			return equipmentService.getDetail(id);
		}catch (Exception e){
			log.debug("设备详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备列表")
	@GetMapping("/getList")
	public BaseResponse getList(){
		try {
			QueryWrapper<Equipment> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("status", 1);
			List<Equipment> list = equipmentService.list(queryWrapper);
			return BaseResponse.okData(list);
		}catch (Exception e){
			log.debug("设备列表{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除设备")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id){
		try {
			equipmentService.removeById(id);
			return BaseResponse.okData("删除成功");
		}catch (Exception e){
			log.debug("删除设备{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}




/*
	@ApiOperation(value = "设备检定详情")
	@GetMapping("getTestDetail/{id}")
	public BaseResponse getTestDetail(@PathVariable Integer id){
		try {
			return equipmentService.getTestDetail(id);
		}catch (Exception e){
			log.debug("设备检定详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}
*/


	@ApiOperation(value = "设备故障维修登记 （不传id为添加记录，传id为修改记录）")
	@PostMapping("/troubleshooting")
	public BaseResponse troubleshooting(@RequestBody EquipmentTroubleshootingQuery query) {
		try {
			return equipmentService.troubleshooting(query);
		}catch (Exception e) {
			log.debug("设备故障维修登记{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备故障维修登记分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "设备名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getTroubleshootingPage")
	public BaseResponse getTroubleshootingPage(PageQuery pageQuery, String name) {
		try {
			return equipmentService.getTroubleshootingPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("设备故障维修登记分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("设备维修列表导出")
	@PostMapping("/exportTroubleshooting")
	public void exportTroubleshooting( String name, String fileName, HttpServletResponse response) {
		try {
			equipmentService.exportTroubleshooting(name, fileName, response);
		} catch (Exception e) {
			log.debug("设备维修列表导出{}", e);
		}
	}

	@ApiOperation(value = "维修登记详情")
	@GetMapping("getTroubleshootingDetail/{id}")
	public BaseResponse getTroubleshootingDetail(@PathVariable Integer id){
		try {
			return equipmentService.getTroubleshootingDetail(id);
		}catch (Exception e){
			log.debug("维修登记详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备报废申请")
	@PostMapping("/scrap")
	public BaseResponse scrap(@RequestBody EquipmentScrapQuery query) {
		try {
			return equipmentService.scrap(query);
		}catch (Exception e) {
			log.debug("设备报废申请{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备报废审批")
	@PostMapping("/scrapApproval")
	public BaseResponse scrapApproval(@RequestBody EquipmentScrapApprovalQuery query) {
		try {
			return equipmentService.scrapApproval(query);
		}catch (Exception e) {
			log.debug("设备报废审批{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "报废申请分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "brand", value = "设备品牌", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "supplierId", value = "供应商表id", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "name", value = "设备名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getScrapApprovalPage")
	public BaseResponse getScrapApprovalPage(PageQuery pageQuery, String brand, Integer supplierId, String name) {
		try {
			return equipmentService.getScrapApprovalPage(pageQuery, brand, supplierId, name);
		} catch (Exception e) {
			log.debug("报废申请分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("报废申请列表导出")
	@PostMapping("/exportScrapApproval")
	public void exportScrapApproval(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response) {
		try {
			equipmentService.exportScrapApproval(brand, supplierId, name, fileName, response);
		} catch (Exception e) {
			log.debug("报废申请列表导出{}", e);
		}
	}

	@ApiOperation(value = "报废申请详情")
	@GetMapping("getscrapApprovalDetail/{id}")
	public BaseResponse getscrapApprovalDetail(@PathVariable Integer id){
		try {
			return equipmentService.getscrapApprovalDetail(id);
		}catch (Exception e){
			log.debug("报废申请详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备使用记录分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "brand", value = "设备品牌", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "supplierId", value = "供应商表id", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "name", value = "设备名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getUsePage")
	public BaseResponse getUsePage(PageQuery pageQuery, String brand, Integer supplierId, String name) {
		try {
			return equipmentService.getUsePage(pageQuery, brand, supplierId, name);
		} catch (Exception e) {
			log.debug("设备使用记录分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("设备使用记录导出")
	@PostMapping("/exportUse")
	public void exportUse(String brand, Integer supplierId, String name, String fileName, HttpServletResponse response) {
		try {
			equipmentService.exportUse(brand, supplierId, name, fileName, response);
		} catch (Exception e) {
			log.debug("设备使用记录导出{}", e);
		}
	}


}

