package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.HistoryArchives;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.HistoryArchivesQuery;
import cn.wise.sc.cement.business.service.IHistoryArchivesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "人员详情-历史档案")
@RestController
@RequestMapping("/tcdri/history_archives")
public class HistoryArchivesController {
    private static final Logger log = LoggerFactory.getLogger("HistoryArchivesController");

    @Autowired
    private IHistoryArchivesService iHistoryArchivesService;

    @ApiOperation(value = "历史档案分页,可通过用户id查询信息")
    @GetMapping("/getPage")
    public BaseResponse getPage(PageQuery pageQuery,Integer userId) {
        try {
            return iHistoryArchivesService.getPage(pageQuery,userId);
        } catch (Exception e) {
            log.debug("历史档案分页列表{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }



    @ApiOperation(value = "根据默认ID查找历史档案信息")
    @GetMapping("/{id}")
    public BaseResponse getById(@PathVariable Integer id){
        try {
            HistoryArchives e = iHistoryArchivesService.getById(id);
            if(e == null){
                return BaseResponse.errorMsg("信息错误!");
            }
            return BaseResponse.okData(e);
        }catch (Exception e){
            log.debug("档案信息详情{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "获取所有历史档案信息")
    @GetMapping("/getList")
    public BaseResponse getList() {
        try {
            return iHistoryArchivesService.getList();
        } catch (Exception e) {
            log.debug("获取其的历史档案信息{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "新增历史档案")
    @PostMapping("/create")
    public BaseResponse create(@RequestBody HistoryArchivesQuery query){
        try {
            return iHistoryArchivesService.create(query);
        }catch (Exception e){
            log.debug("新增历史档案{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "更新历史档案")
    @PostMapping("/update")
    public BaseResponse update(@RequestBody HistoryArchivesQuery historyArchivesQuery){
        try {
            return iHistoryArchivesService.update(historyArchivesQuery);
        }catch (Exception e){
            log.debug("更新历史档案{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "删除历史档案")
    @PostMapping("/delete/{id}")
    public BaseResponse delete(@PathVariable Integer id){
        try {
            return iHistoryArchivesService.delete(id);
        }catch (Exception e){
            log.debug("删除历史档案{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

}
