package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import cn.wise.sc.cement.business.model.vo.QualityDetailVo;
import cn.wise.sc.cement.business.service.IEntrustService;
import cn.wise.sc.cement.business.service.IQualityApplyService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @description: Quality
 * @author: qh
 * @create: 2020-09-28 09:49
 **/
@Api(tags = "质量管理")
@Slf4j
@RestController
@RequestMapping("/business/quality")
public class QualityController {

    final
    IEntrustService iEntrustService;
    final
    IQualityApplyService iQualityApplyService;

    public QualityController(IEntrustService iEntrustService, IQualityApplyService iQualityApplyService) {
        this.iEntrustService = iEntrustService;
        this.iQualityApplyService = iQualityApplyService;
    }

    @ApiOperation(value = "质量检测分页列表")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "clientId", value = "委托单位id", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "projectName", value = "项目名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "projectCode", value = "项目编号", paramType = "query", dataType = "String")
    })
    @GetMapping("/getPage")
    public BaseResponse<IPage<EntrustVo>> page(PageQuery pageQuery, String startDate, String endDate,
                                               Integer clientId, String projectName, String projectCode) {
        BaseResponse<IPage<EntrustVo>> baseResponse = iEntrustService.getQualityPage(
                pageQuery, startDate, endDate, clientId, projectName, projectCode);

        //判断是否已经评审过
        if (baseResponse.getCode() == 200) {

            List<EntrustVo> records = baseResponse.getData().getRecords();
            if (records.size() == 0) {
                return BaseResponse.errorMsg("没找到相关数据!");
            }
            List<Integer> projectIds = records.stream().map(EntrustVo::getId).collect(Collectors.toList());
            Set<Integer> qualityApplyIds = iQualityApplyService.selectQualityApplyStatusByProIds(projectIds);
            records.forEach(arg->{
                if (qualityApplyIds.contains(arg.getId())){
                    arg.setStatusValue("审核完成");
                    arg.setStatus(10);
                }else {
                    arg.setStatusValue("待审核");
                    arg.setStatus(9);
                }
            });
        }
        return baseResponse;
    }

    @GetMapping("/{entrustId}")
    @ApiOperation("获取质量详情")
    public BaseResponse<QualityDetailVo> getReportDetail(@PathVariable("entrustId") Integer entrustId) {
        return BaseResponse.okData(iEntrustService.getQualityDetail(entrustId));
    }


}
