package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.service.impl.WeiXinService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import cn.wise.sc.cement.business.wrapper.Wrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "微信接口")
@RestController
@RequestMapping("/tcdri/weixin")
public class WeiXinController {

	private static final Logger log = LoggerFactory.getLogger("WeiXinController");

	@Autowired
	private WeiXinService weiXinService;

	@ApiOperation(value = "获取登录token")
	@GetMapping("/getToken")
	public BaseResponse getToken(String code){
		try {
			return weiXinService.getToken(code);
		}catch (Exception e){
			log.debug("获取登录token{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "当前登录用户")
	@GetMapping("/getLoginUser")
	public BaseResponse getLoginUser(){
		try {
			return weiXinService.getLoginUser();
		}catch (Exception e){
			log.debug("当前登录用户{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}



}
