package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 能力管理
 * </p>
 *
 * @author wlb
 * @since 2020-09-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CapabilityManagement implements Serializable {

  private static final long serialVersionUID = 1L;

  /*
  主键
   */
  @TableId(value = "id",type = IdType.AUTO)
  private Integer id;

  @ApiModelProperty("能力项")
  private String capabilityItem;

  @ApiModelProperty("能力范围")
  private String capabilityRange;

  @ApiModelProperty("取得日期")
  private LocalDate obtainTime;

  @ApiModelProperty("创建日期")
  private LocalDateTime createTime;

  @ApiModelProperty("修改日期")
  private LocalDateTime updateTime;

  @ApiModelProperty("备注")
  private String remark;

  @ApiModelProperty
  private Integer userId;
}
