package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SampleCheckTeam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("校核表id")
    private Integer checkId;

    @ApiModelProperty("样品表d")
    private Integer sampleId;

    @ApiModelProperty("平行样编号")
    private String parallelCode;

    @ApiModelProperty("处理人id")
    private Integer userId;

    @ApiModelProperty("检测设备表id")
    private Integer equipmentId;

    @ApiModelProperty("检测设备名称")
    private String equipmentName;

    /**
     * json串
     * {"样重m":"40","K值":1.0274,"Vsio2":3.89,................}
     */
    @ApiModelProperty("校核人员输入检测结果 json串")
    private String inputResult;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;
}
