package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-10-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SysUserMessage implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
      @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 接收人id
     */
    private Integer userId;

    /**
     * 接收信息
     */
    private String message;

    /**
     * 相关内容(委托表id)
     */
    private Integer appId;

    /**
     * 是否查看(0:否，1：是)
     */
    private Integer isCheck;

    /**
     * 消息类型(1委托管理)
     */
    private Integer messageType;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 是否处理(0:未处理，1：已处理)
     */
    private Integer isDeal;



    public interface MessageType {
        int ENTRUST = 1;

    }


}
