package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.QualityApply;
import cn.wise.sc.cement.business.mapper.QualityApplyMapper;
import cn.wise.sc.cement.business.service.IQualityApplyService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.Data;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-10-12
 */
@Service
public class QualityApplyServiceImpl extends ServiceImpl<QualityApplyMapper, QualityApply>
        implements IQualityApplyService {

    @Override
    public Set<Integer> selectQualityApplyStatusByProIds(List<Integer> projectIds) {
        if (projectIds.size() == 0) {
            return new HashSet<>();
        }
        QueryWrapper<QualityApply> qw = new QueryWrapper<>();
        qw.in("project_id", projectIds);
        List<QualityApply> list = this.list(qw);
        if (list.size() == 0) {
            return new HashSet<>();
        }
        return list.stream().map(QualityApply::getProjectId).collect(Collectors.toSet());
    }

    @Override
    public void exportQuality(Date startParse, Date endParse, HttpServletResponse response) {

        QueryWrapper<QualityApply> qw = new QueryWrapper<>();
        if (startParse != null) {
            qw.ge("create_time", startParse);
        }
        if (endParse != null) {
            qw.le("create_time", endParse);
        }
        List<QualityApply> list = this.list(qw);
        //找到所有项目id归类
        Set<Integer> projectIds = list.stream().map(QualityApply::getProjectId).collect(Collectors.toSet());
        String[] headers = new String[30];
        List<Object[]> datas = new ArrayList<>();
        for (Integer projectId : projectIds) {
            //找到每个项目的检测组  以检测组归类
            Set<Integer> teamIds = list.stream()
                    .filter(arg -> arg.getProjectId().intValue() == projectId)
                    .map(QualityApply::getTeamGroupId)
                    .collect(Collectors.toSet());

            for (Integer teamId : teamIds) {
                List<QualityApply> samples = list.stream().filter(arg -> arg.getTeamGroupId().intValue() == teamId
                        && arg.getProjectId().intValue() == projectId)
                        .collect(Collectors.toList());
                //以样品归类
                Set<Integer> sampleIds = samples.stream().map(QualityApply::getTeamGroupId)
                        .collect(Collectors.toSet());

                //写每个样品的表头
                list.stream()
                        .filter(arg -> arg.getTeamGroupId().intValue() == teamId )
                        .findFirst().ifPresent(arg -> {
                    List<String> teams = JSON.parseArray(arg.getTeams(), String.class);
                    Object[] objs = new Object[teams.size() + 7];
                    objs[0] = "项目名称";
                    objs[1] = "项目编号";
                    objs[2] = "样品名称";
                    objs[3] = "样品状态";
                    objs[4] = "来样编号";
                    objs[5] = "本所编号";
                    objs[6] = "分析";
                    for (int i = 0; i < teams.size(); i++) {
                        objs[7 + i] = teams.get(i);
                    }
                    datas.add(objs);
                });
                //为每个样品写值
                samples.forEach(arg -> {
                    List<String> inputValus = JSON.parseArray(arg.getInputResult(), String.class);
                    Object[] objs = new Object[inputValus.size() + 7];
                    if (!"误差".equals(arg.getUserName())) {
                        objs[0] = arg.getProjectName();
                        objs[1] = arg.getProjectId();
                        objs[2] = arg.getSampleName();
                        objs[3] = arg.getSampleForm();
                        objs[4] = arg.getSampleCode();
                        objs[5] = arg.getCementCode();
                    }
                    //添加名字
                    objs[6] = arg.getUserName();
                    for (int i = 0; i < inputValus.size(); i++) {
                        objs[7 + i] = inputValus.get(i);
                    }
                    for (int i = 0; i < inputValus.size(); i++) {
                        objs[7 + i] = inputValus.get(i);
                    }
                    datas.add(objs);
                });

            }
        }
        ExcelUtil.excelExport("qualityApply", headers, datas, response);
    }

}
