package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.Method;
import cn.wise.sc.cement.business.entity.Sample;
import cn.wise.sc.cement.business.entity.SampleTmp;
import cn.wise.sc.cement.business.entity.Team;
import cn.wise.sc.cement.business.mapper.SampleMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.SampleManageQuery;
import cn.wise.sc.cement.business.model.vo.SampleVo;
import cn.wise.sc.cement.business.service.ISampleService;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Service
public class SampleServiceImpl extends ServiceImpl<SampleMapper, Sample> implements ISampleService {

	@Resource
	private SampleMapper sampleMapper;
	@Autowired
	private ISysUserService userService;



	/**
	 * 分页列表
	 * @param pageQuery
	 * @param sampleName
	 * @param cementCode
	 * @return
	 */
	@Override
	public BaseResponse<IPage<SampleVo>> getPage(PageQuery pageQuery, String sampleName, String cementCode){
		Map<String, Object> params = new HashMap<>();
		params.put("sampleName", sampleName);
		params.put("cementCode", cementCode);
		Page<SampleVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<SampleVo> pages = sampleMapper.getPage(page, params);
		return BaseResponse.okData(pages);
	}

	/**
	 *  样品管理详情
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<SampleVo> getDetail(Integer id){
		SampleVo sampleVo = sampleMapper.getDetail(id);
		if(sampleVo == null ){
			return BaseResponse.errorMsg("信息错误!");
		}
		return BaseResponse.okData(sampleVo);
	}

	/**
	 * 样品登记
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> register(SampleManageQuery query) {
		if (query.getId() == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		Sample sample = sampleMapper.selectById(query.getId());
		if(sample == null){
			return BaseResponse.errorMsg("信息错误");
		}
		sample.setOperatorId(userService.getLoginUser().getId())
				.setRegisterTime(LocalDateTime.now())
				.setHandleDate(query.getHandleDate())
				.setLittlePosition(query.getLittlePosition())
				.setOriginalPosition(query.getOriginalPosition())
				.setRemark(query.getRemark());
		sampleMapper.updateById(sample);
		return BaseResponse.okData("样品登记成功");
	}

	/**
	 * 样品销毁
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> destruction(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		Sample sample = sampleMapper.selectById(id);
		if(sample == null){
			return BaseResponse.errorMsg("信息错误");
		}
		sample.setStatus(2)
				.setDestructionTime(LocalDateTime.now());
		sampleMapper.updateById(sample);
		return BaseResponse.okData("样品已销毁");
	}

	/**
	 * 样品列表导出
	 * @param sampleName
	 * @param cementCode
	 * @param fileName
	 * @param response
	 */
	public void export(String sampleName, String cementCode,
	                   String fileName, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("sampleName", sampleName);
		params.put("cementCode", cementCode);
		List<Map<String, Object>> list = sampleMapper.exportList(params);

		if (!CollectionUtils.isEmpty(list)) {
			Map<String, Object> map = list.get(0);
			String[] headers = new String[map.size()];
			headers[0] = "序号";
			headers[1] = "样品名称";
			headers[2] = "样品本所编号";
			headers[3] = "所属项目";
			headers[4] = "小样信息";
			headers[5] = "原样存储";
			headers[6] = "样品重量（kg）";
			headers[7] = "是否为平行样";
			headers[8] = "状态";
			List<Object[]> datas = new ArrayList<>(headers.length);
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]).toString();
					//如果序号带小数点 去除.0,保留整数
					if (j == 0) {
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}
				datas.add(objects);
			}
			ExcelUtil.excelExport(
					fileName == null || fileName.trim().length() <= 0 ? "样品列表" : fileName, headers,
					datas, response);
		}
	}






}
