package cn.wise.sc.cement.business.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.wise.sc.cement.business.entity.SysUser;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.service.ISysUserService;
import cn.wise.sc.cement.business.util.JwtUtil;
import cn.wise.sc.cement.business.util.RedisUtil;
import cn.wise.sc.cement.business.util.weixin.Global;
import cn.wise.sc.cement.business.util.weixin.WeixinInterfaceUtil;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import cn.wise.sc.cement.business.wrapper.Wrapper;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@Service
public class WeiXinService {

	@Value("${weixin.corpid}")
	private String corpid;
	@Value("${weixin.corpsecret}")
	private String corpsecret;
	@Autowired
	private ISysUserService userService;
	@Autowired
	RedisUtil redisUtil;

	/**
	 * 获取登录token
	 * @param code
	 * @return
	 */
	public BaseResponse<String> getToken(String code) {
		if (StrUtil.isEmpty(code)) {
			return BaseResponse.errorMsg("code为必填项!");
		}
		System.out.println("==================code===================");
		System.out.println(code);
		try {
//			String accessToken = getAccessToken();
//			String param = "access_token=%s&code=%s";
//			param = String.format(param, accessToken, code);
//			JSONObject jsonObject = WeixinInterfaceUtil.doGet(Global.USERINFOURL, param);
//			if(jsonObject.get("errcode").toString().equals("40029")){
//				return BaseResponse.errorMsg("code失效!");
//			}
//			String UserId = jsonObject.getString("UserId");
//			System.out.println("==================UserId===================");
//			System.out.println(UserId);
//			JSONObject userJson = getUser(accessToken, UserId);
			QueryWrapper<SysUser> wrapper = new QueryWrapper<>();
//			wrapper.eq("phone", userJson.get("mobile"));
			wrapper.eq("phone", code);  //暂时用手机号代替code
			SysUser sysUser = userService.getOne(wrapper);
			if(sysUser == null){
				return BaseResponse.errorMsg("非系统用户不允许登录!");
			}
			if(sysUser.getStatus()==0){
				return BaseResponse.errorMsg("用户被禁用!");
			}
			if(sysUser.getIsDelete()==0){
				return BaseResponse.errorMsg("用户被删除!");
			}
			//生成token,存入redis
			String token = JwtUtil.createToken(sysUser.getId(), sysUser.getUsername(),
					sysUser.getName(), sysUser.getPhone());
			System.out.println(token);
			redisUtil.setString(sysUser.getId().toString(),token,3600);
			return BaseResponse.okData(token);
		} catch (Exception e) {
			return BaseResponse.errorMsg(e.getMessage());
		}
	}

	//获取accessToken信息
	public String getAccessToken() {
		try {
			String param = "corpid=%s&corpsecret=%s";
			param = String.format(param, corpid, corpsecret);
			JSONObject jsonObject = WeixinInterfaceUtil.doGet(Global.ACCESSTOKENURL, param);
			String accessToken = jsonObject.getString("access_token");
			System.out.println("==================accessToken===================");
			System.out.println(accessToken);
			return accessToken;
		} catch (Exception e) {
			return null;
		}
	}

	//获取用户信息
	public JSONObject getUser(String accessToken, String userId) {
		try {
			String param = "access_token=%s&userid=%s";
			param = String.format(param, accessToken, userId);
			JSONObject jsonObject = WeixinInterfaceUtil.doGet(Global.USERURL, param);
			System.out.println("==================jsonObject===================");
			System.out.println(jsonObject);
			return jsonObject;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * 当前登录用户
	 * @return
	 */
	public BaseResponse<LoginUser> getLoginUser() {
		LoginUser loginUser = userService.getLoginUser();
		return BaseResponse.okData(loginUser);
	}

























}
