package cn.wise.sc.cement.business.config.lock;

import org.redisson.api.RLock;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class RedissLockUtil {
    private static DistributedLocker redissLock;
    
    public static void setLocker(DistributedLocker locker) {
        redissLock = locker;
    }

    public static RLock lock(String lockKey) {
        return redissLock.lock(lockKey);
    }


    public static <T> T readWriteLock(String lockKey, Function<String,T> function) {
         return redissLock.executeLock(lockKey,function,null);
    }

    public static <T> void playersLock(String lockKey, Consumer<T> consumer,T t){
        redissLock.executeLock(lockKey,consumer,null);
    }

    public static void unlock(String lockKey) {
        redissLock.unlock(lockKey);
    }

    public static void unlock(RLock lock) {
        redissLock.unlock(lock);
    }

    public static RLock lock(String lockKey, int timeout) {
        return redissLock.lock(lockKey, timeout);
    }

    public static RLock lock(String lockKey, TimeUnit unit , int timeout) {
        return redissLock.lock(lockKey, unit, timeout);
    }

    public static boolean tryLock(String lockKey, int waitTime, int leaseTime) {
        return redissLock.tryLock(lockKey, TimeUnit.SECONDS, waitTime, leaseTime);
    }

    public static boolean tryLock(String lockKey, TimeUnit unit, int waitTime, int leaseTime) {
        return redissLock.tryLock(lockKey, unit, waitTime, leaseTime);
    }
}