package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.NonStandardApproval;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApprovalQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardApprovalVo;
import cn.wise.sc.cement.business.service.INonStandardApprovalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
@Api(tags="非标产值-非标产值审批")
@RestController
@RequestMapping("/tcdri/nonestandard_approval")
public class NonStandardApprovalController {
	private static final Logger log = LoggerFactory.getLogger("NoneStandardApprovalController");

	@Autowired
	private INonStandardApprovalService iNonStandardApprovalService;

	@ApiOperation(value = "非标产值审批分页")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery,String name,Integer status) {
		try {
			return iNonStandardApprovalService.getPage(pageQuery,name,status);
		} catch (Exception e) {
			log.debug("非标产值审批分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据id查询指定非标产值审批信息")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			BaseResponse<List<NonStandardApprovalVo>> e = iNonStandardApprovalService.getById(id);
			if(e == null){
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(e);
		}catch (Exception e){
			log.debug("通过id查询非标产值审批信息{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取所有非标产值审批")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return iNonStandardApprovalService.getList();
		} catch (Exception e) {
			log.debug("获取所有的非标产值审批{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "审批通过/驳回")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody NonStandardApprovalQuery nonStandardApprovalQuery){
		try {
			return iNonStandardApprovalService.update(nonStandardApprovalQuery);
		}catch (Exception e){
			log.debug("审批通过/驳回{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "审批操作按钮实现")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id){
		try {
			return iNonStandardApprovalService.status(status, id);
		}catch (Exception e){
			log.debug("审批操作实现{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除非标产值审批")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id){
		try {
			return iNonStandardApprovalService.delete(id);
		}catch (Exception e){
			log.debug("删除非标产值审批{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("委托单位审批导出列表")
	@PostMapping("/exportList")
	public void exportList(Integer status,String filename, String userId, String name, HttpServletResponse response) {
		try {
			iNonStandardApprovalService.exportList(status, filename, userId, name, response);
		} catch (Exception e) {
			log.debug("非标产值申请导出列表{}", e);
		}
	}
}
