package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanConsumablesPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanStandardPurchaseQuery;
import cn.wise.sc.cement.business.service.IPlanConsumablesPurchaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Api(tags="计划管理-消耗品采购计划")
@RestController
@RequestMapping("/business/plan-consumables-purchase")
public class PlanConsumablesPurchaseController {

	private static final Logger log = LoggerFactory.getLogger("PlanConsumablesPurchaseController");

	@Autowired
	private IPlanConsumablesPurchaseService consumablesPurchaseService;


	@ApiOperation(value = "消耗品采购计划分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "产品名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return consumablesPurchaseService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("消耗品采购计划分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增消耗品采购计划")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PlanConsumablesPurchaseQuery query){
		try {
			return consumablesPurchaseService.create(query);
		}catch (Exception e){
			log.debug("新增消耗品采购计划{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新消耗品采购计划")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PlanConsumablesPurchaseQuery query){
		try {
			return consumablesPurchaseService.update(query);
		}catch (Exception e){
			log.debug("更新消耗品采购计划{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "消耗品采购计划详情")
	@GetMapping("/{id}")
	public BaseResponse getDetail(@PathVariable Integer id){
		try {
			return consumablesPurchaseService.getDetail(id);
		}catch (Exception e){
			log.debug("消耗品采购计划详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "采购完成")
	@PostMapping("/finish")
	public BaseResponse finish(Integer id){
		try {
			return consumablesPurchaseService.finish(id);
		}catch (Exception e){
			log.debug("采购完成{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id){
		try {
			return consumablesPurchaseService.delete(id);
		}catch (Exception e){
			log.debug("删除{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

}

