package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import cn.wise.sc.cement.business.service.IPlanEquipmentPurchaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Api(tags="计划管理-设备采购计划")
@RestController
@RequestMapping("/business/plan-equipment-purchase")
public class PlanEquipmentPurchaseController {

	private static final Logger log = LoggerFactory.getLogger("PlanEquipmentPurchaseController");

	@Autowired
	private IPlanEquipmentPurchaseService equipmentPurchaseService;

	@ApiOperation(value = "设备采购计划分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "产品名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return equipmentPurchaseService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("设备采购计划分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增设备采购计划")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody PlanEquipmentPurchaseQuery query){
		try {
			return equipmentPurchaseService.create(query);
		}catch (Exception e){
			log.debug("新增设备采购计划{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新设备采购计划")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody PlanEquipmentPurchaseQuery query){
		try {
			return equipmentPurchaseService.update(query);
		}catch (Exception e){
			log.debug("更新设备采购计划{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "设备采购计划详情")
	@GetMapping("/{id}")
	public BaseResponse getDetail(@PathVariable Integer id){
		try {
			return equipmentPurchaseService.getDetail(id);
		}catch (Exception e){
			log.debug("设备采购计划详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "采购完成")
	@PostMapping("/finish")
	public BaseResponse finish(Integer id){
		try {
			return equipmentPurchaseService.finish(id);
		}catch (Exception e){
			log.debug("采购完成{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id){
		try {
			return equipmentPurchaseService.delete(id);
		}catch (Exception e){
			log.debug("删除{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


}

