package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.EntrustReport;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import cn.wise.sc.cement.business.model.vo.QualityDetailVo;
import cn.wise.sc.cement.business.service.IEntrustService;
import cn.wise.sc.cement.business.util.PageUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: Quality
 * @author: qh
 * @create: 2020-09-28 09:49
 **/
@Api(tags = "质量管理")
@Slf4j
@RestController
@RequestMapping("/business/quality")
public class QualityController {

    final
    IEntrustService iEntrustService;

    public QualityController(IEntrustService iEntrustService) {
        this.iEntrustService = iEntrustService;
    }

    @ApiOperation(value = "质量检测分页列表")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "clientId", value = "委托单位id", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "projectName", value = "项目名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "projectCode", value = "项目编号", paramType = "query", dataType = "String")
    })
    @GetMapping("/getPage")
    public BaseResponse<IPage<EntrustVo>> page(PageQuery pageQuery, String startDate, String endDate,
                                               Integer clientId, String projectName, String projectCode) {
        return iEntrustService.getQualityPage(pageQuery, startDate, endDate, clientId, projectName, projectCode);
    }

    @GetMapping("/{entrustId}")
    @ApiOperation("获取质量详情")
    public BaseResponse<QualityDetailVo> getReportDetail(@PathVariable("entrustId") Integer entrustId) {

        return BaseResponse.okData(iEntrustService.getQualityDetail(entrustId));
    }


}
