package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.ReportDetailVo;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import cn.wise.sc.cement.business.service.IEntrustService;
import cn.wise.sc.cement.business.util.WordUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @description: 报告管理
 * @author: qh
 * @create: 2020-09-25 14:37
 **/
@Api(tags = "报告管理")
@Slf4j
@RestController
@RequestMapping("/business/report")
public class ReportController {

    final
    IEntrustService iEntrustService;

    public ReportController(IEntrustService iEntrustService) {
        this.iEntrustService = iEntrustService;

    }

    @ApiOperation(value = "报告分页列表")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "startDate", value = "开始日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "clientId", value = "委托单位id", paramType = "query", dataType = "Integer"),
            @ApiImplicitParam(name = "projectName", value = "项目名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "projectCode", value = "项目编号", paramType = "query", dataType = "String")
    })
    @GetMapping("/getPage")
    public BaseResponse<IPage<EntrustVo>> page(PageQuery pageQuery, String startDate, String endDate,
                                               Integer clientId, String projectName, String projectCode) {
        return iEntrustService.getReportPage(pageQuery, startDate, endDate, clientId, projectName, projectCode);
    }

    @ApiOperation(value = "置顶取消置顶 (createTime = updateTime显示置顶，否则显示取消置顶)")
    @PostMapping("/setTopping")
    public BaseResponse<String> setTopping(Integer id) {
        try {
            return iEntrustService.setTopping(id);
        } catch (Exception e) {
            log.debug("置顶取消置顶 {}", e.getMessage());
        }
        return BaseResponse.errorMsg("失败!");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("删除报告")
    public BaseResponse<Boolean> deleteById(@PathVariable("id") Integer id) {
        return iEntrustService.deleteById(id);
    }

    @GetMapping("/{entrustId}")
    @ApiOperation("获取报告详情")
    public void getReportDetail(@PathVariable("entrustId") Integer entrustId,
                                HttpServletResponse response) {

        ReportDetailVo rts = iEntrustService.getReportDetail(entrustId);

        Map<String, Object> beanParams = new HashMap<>(10);
        beanParams.put("sendName", rts.getSendName());
        beanParams.put("sender", rts.getSender());
        beanParams.put("sendDate", rts.getSendDate());
        beanParams.put("sampleNum", rts.getSampleNum());
        beanParams.put("sampleNames", set2String(rts.getSampleNames()));
        beanParams.put("teamNames", set2String(rts.getTeamNames()));
        beanParams.put("methodNames", set2StringN(rts.getMethodNames()));
        beanParams.put("equipmentNames", set2StringN(rts.getEquipmentNames()));
        beanParams.put("projectName", rts.getProjectName());
        beanParams.put("printDate", rts.getPrintDate());

        WordUtil.writeWordReport(rts.getProjectName() + "(报告)", "report.ftl",
                beanParams, response);

    }

    private String set2String(Set<String> source) {
        if (source.size() == 0) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder();
        for (String target : source) {
            strBuilder.append("、").append(target);
        }
        return strBuilder.replace(0, 1, "").toString();
    }

    private String set2StringN(Set<String> source) {
        if (source.size() == 0) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder();
        for (String target : source) {
            strBuilder.append("&#10;").append(target);
        }

        return strBuilder.replace(0,5,"").toString();
    }
}
