package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.SysApproval;
import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.service.ISysApprovalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-21
 */
@Api(tags="系统管理-审批管理")
@RestController
@RequestMapping("/business/sys-approval")
public class SysApprovalController {

	private static final Logger log = LoggerFactory.getLogger("SysApprovalController");

	@Autowired
	private ISysApprovalService approvalService;


	@ApiOperation(value = "审批分页列表")
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery) {
		try {
			return approvalService.getPage(pageQuery);
		} catch (Exception e) {
			log.debug("审批分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增审批")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody SysApproval query) {
		try {
			return approvalService.create(query);
		}catch (Exception e) {
			log.debug("新增审批{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改审批")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody SysApproval query) {
		try {
			return approvalService.update(query);
		}catch (Exception e) {
			log.debug("修改审批{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "审批详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			SysApproval approval = approvalService.getById(id);
			if(approval == null){
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(approval);
		}catch (Exception e){
			log.debug("审批详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}




}

