package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.SysPermission;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.service.ISysPermissionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-20
 */
@Api(tags="系统管理-权限管理")
@RestController
@RequestMapping("/business/sys-permission")
public class SysPermissionController {

	private static final Logger log = LoggerFactory.getLogger("SysPermissionController");

	@Autowired
	private ISysPermissionService permissionService;

	@ApiOperation(value = "当前登录用户拥有的权限")
	@GetMapping("/current")
	public BaseResponse permissionsCurrent() {
		try {
			return permissionService.current();
		}catch (Exception e) {
			log.debug("当前登录用户拥有的权限{}",e);
		}
		return BaseResponse.errorMsg("失败!");

	}

	@ApiOperation(value = "菜单列表")
	@GetMapping("/permissionsList")
	public BaseResponse permissionsList() {
		try {
			return permissionService.permissionsList();
		}catch (Exception e) {
			log.debug("菜单列表{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "一级菜单")
	@GetMapping("/parents")
	public BaseResponse parentMenu() {
		try {
			return permissionService.parents();
		}catch (Exception e) {
			log.debug("一级菜单{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "菜单树")
	@GetMapping("/tree")
	public BaseResponse tree() {
		try {
			return permissionService.tree();
		}catch (Exception e) {
			log.debug("菜单树{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "根据角色id获取权限")
	@GetMapping("/listByRoleId")
	public BaseResponse listByRoleId(Integer roleId) {
		try {
			return permissionService.listByRoleId(roleId);
		}catch (Exception e) {
			log.debug("根据角色id获取权限{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@ApiOperation(value = "保存菜单")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody SysPermission permission) {
		try {

			return permissionService.create(permission);
		}catch (Exception e) {
			log.debug("保存菜单{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改菜单")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody SysPermission permission) {
		try {
			return permissionService.update(permission);
		}catch (Exception e) {
			log.debug("修改菜单{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@GetMapping("/{id}")
	@ApiOperation(value = "菜单详情")
	public BaseResponse get(@PathVariable Integer id) {
		try {
			SysPermission permission = permissionService.getById(id);
			return BaseResponse.okData(permission);
		}catch (Exception e) {
			log.debug("根据菜单id获取菜单{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


	@PostMapping("/delete/{id}")
	@ApiOperation(value = "删除菜单")
	@Transactional
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			permissionService.removeById(id);
			return BaseResponse.okMsg("成功");
		}catch (Exception e) {
			log.debug("删除菜单{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}


}

