package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.Project;
import cn.wise.sc.cement.business.entity.Team;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.PageTableRequest;
import cn.wise.sc.cement.business.model.query.ProjectQuery;
import cn.wise.sc.cement.business.model.query.TeamQuery;
import cn.wise.sc.cement.business.service.ITeamService;
import cn.wise.sc.cement.business.wrapper.WrapMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-08-18
 */
@Api(tags = "配置管理-检测项配置")
@RestController
@RequestMapping("/business/team")
public class TeamController {

	private static final Logger log = LoggerFactory.getLogger("TeamController");

	@Autowired
	private ITeamService teamService;

	@ApiOperation(value = "检测项分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "status", value = "状态0:禁用 1:启用", paramType = "query", dataType = "Integer"),
			@ApiImplicitParam(name = "groupName", value = "检测组名称", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "name", value = "检测项目名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, Integer status, String groupName, String name) {
		try {
			return teamService.getPage(pageQuery, status, groupName, name);
		} catch (Exception e) {
			log.debug("检测项分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增检测项")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody TeamQuery query){
		try {
			return teamService.create(query);
		}catch (Exception e){
			log.debug("新增检测项{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "更新检测项")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody TeamQuery query){
		try {
			return teamService.update(query);
		}catch (Exception e){
			log.debug("更新检测项{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "启用禁用")
	@PostMapping("/status")
	public BaseResponse status(Integer status, Integer id){
		try {
			return teamService.status(status, id);
		}catch (Exception e){
			log.debug("启用禁用{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检测项详情")
	@GetMapping("/{id}")
	public BaseResponse getDetail(@PathVariable Integer id){
		try {
			return teamService.getDetail(id);
		}catch (Exception e){
			log.debug("检测项详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检测项列表")
	@GetMapping("/getList")
	public BaseResponse getList() {
		try {
			return teamService.getList();
		} catch (Exception e) {
			log.debug("检测项列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("检测项导出")
	@PostMapping("/export")
	public void export(Integer status, Integer gourpId, String name, String fileName, HttpServletResponse response) {
		try {
			teamService.export(status, gourpId, name, fileName, response);
		} catch (Exception e) {
			log.debug("检测项导出{}", e);
		}
	}

	@ApiOperation(value = "根据检测组id获取检测项信息")
	@GetMapping("/getByGroup")
	public BaseResponse getByGroup(Integer id) {
		try {
			return teamService.getByGroup(id);
		} catch (Exception e) {
			log.debug("根据检测组id获取检测项信息{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}




}

