package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.entity.SysGroup;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.TeamGroupQuery;
import cn.wise.sc.cement.business.service.ITeamGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-10
 */
@Api(tags="配置管理-检测组配置")
@RestController
@RequestMapping("/business/team-group")
public class TeamGroupController {

	private static final Logger log = LoggerFactory.getLogger("TeamGroupController");

	@Autowired
	private ITeamGroupService teamGroupService;

	@ApiOperation(value = "检测组分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "name", value = "检测组名称", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String name) {
		try {
			return teamGroupService.getPage(pageQuery, name);
		} catch (Exception e) {
			log.debug("检测组分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "新增检测组")
	@PostMapping("/create")
	public BaseResponse create(@RequestBody TeamGroupQuery query) {
		try {
			return teamGroupService.create(query);
		}catch (Exception e) {
			log.debug("新增检测组{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "修改检测组")
	@PostMapping("/update")
	public BaseResponse update(@RequestBody TeamGroupQuery query) {
		try {
			return teamGroupService.update(query);
		}catch (Exception e) {
			log.debug("修改检测组{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检测组详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			TeamGroup group = teamGroupService.getById(id);
			if(group == null){
				return BaseResponse.errorMsg("信息错误!");
			}
			return BaseResponse.okData(group);
		}catch (Exception e){
			log.debug("检测组详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "检测组列表")
	@GetMapping("/getList")
	public BaseResponse getById(){
		try {
			List<TeamGroup> list = teamGroupService.list();
			return BaseResponse.okData(list);
		}catch (Exception e){
			log.debug("检测组列表{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "删除检测组")
	@PostMapping("/delete/{id}")
	public BaseResponse delete(@PathVariable Integer id) {
		try {
			teamGroupService.removeById(id);
			return BaseResponse.okData("删除成功");
		} catch (Exception e) {
			log.debug("删除检测组{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}


}

