package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SampleTmp implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
      @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("来样编号")
    private String sampleCode;

    @ApiModelProperty("样品名")
    private String name;

    @ApiModelProperty("样品状态（粉、块状)")
    private String sampleForm;

    @ApiModelProperty("检测项id 例子：1、2、3")
    private String teamIds;

    @ApiModelProperty("样品照片")
    private String samplePhoto;

    @ApiModelProperty("样品重量(g)")
    private BigDecimal weight;

    @ApiModelProperty("(检测依据编号)  例子：01、23、15")
    private String methodNumbers;

    @ApiModelProperty("委托表id")
    private Integer entrustId;

    @ApiModelProperty("收费标准")
    private BigDecimal charge;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;


}
