package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Supplier implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("供应商名称")
    private String name;

    @ApiModelProperty("经营类型")
    private String manageType;

    @ApiModelProperty("供应商类型（生产商，代理商）")
    private String supplierType;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("联系人电话")
    private String contactsPhone;

    @ApiModelProperty("登记日期")
    private LocalDate registerDate;

    @ApiModelProperty("经营产品")
    private String businessProducts;

    @ApiModelProperty("资质")
    private String qualifications;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

}
