package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.EquipmentUse;
import cn.wise.sc.cement.business.model.vo.EquipmentTestVo;
import cn.wise.sc.cement.business.model.vo.EquipmentUseVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
public interface EquipmentUseMapper extends BaseMapper<EquipmentUse> {

	IPage<EquipmentUseVo> getPage(@Param("page") Page page, @Param("params") Map<String, Object> params);

    /**
     * 根据项目id获取使用到的设备名字
     * @param entrustId 项目id
     * @return list
     */
    List<String> getEquipmentNamesByProjectId(@Param("param") Integer entrustId);
}
