package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.EntrustSample;
import cn.wise.sc.cement.business.entity.SampleHandle;
import cn.wise.sc.cement.business.model.vo.EntrustVo;
import cn.wise.sc.cement.business.model.vo.SampleHandleVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.tomcat.jni.Local;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
@Mapper
public interface SampleHandleMapper extends BaseMapper<SampleHandle> {


	List<SampleHandleVo> getSampleHandleList(@Param("params") Map<String, Object> params);

	SampleHandleVo getDetail(Integer id);

	@Select("select MIN(accept_time) from sample_handle where sample_id = #{sampleId} and status>0")
	LocalDateTime getNo1AcceptTime(Integer sampleId);

    List<EntrustSample> getEntrustSample();
}
