package cn.wise.sc.cement.business.mapper;

import cn.wise.sc.cement.business.entity.Sample;
import cn.wise.sc.cement.business.model.vo.SampleManageVo;
import cn.wise.sc.cement.business.model.vo.SampleVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ztw
 * @since 2020-08-24
 */
public interface SampleMapper extends BaseMapper<Sample> {

	IPage<SampleVo> getPage(@Param("page") Page page, @Param("params") Map<String, Object> params);

	List<Map<String, Object>> exportList(@Param("params") Map<String, Object> params);

	SampleVo getDetail(Integer id);

	@Select("select max(parallel_code) from sample")
	String getMaxCementCode();

	@Select("select * from sample where cement_code = parallel_code and entrust_id = #{entrustId}" +
			" order by id asc ")
	List<Sample> getSampleList(Integer entrustId);

	@Select("select * from sample where cement_code = parallel_code and entrust_id = #{entrustId} " +
			" and is_handle != 1 order by id asc")
	List<Sample> getNoHandleList(Integer entrustId);

	@Select("select * from sample where entrust_id = #{entrustId}  and is_distribution != 1 order by id asc")
	List<Sample> getNoDistributionList(Integer entrustId);

	//校核详情样品列表（不展示平行样副样）
	@Select("select * from sample where cement_code = parallel_code and entrust_id = #{entrustId} " +
			"and is_handle = 1 and is_distribution = 1 order by id asc")
	List<Sample> getCheckSampleList(Integer entrustId);


	@Select("select * from sample where entrust_id = #{entrustId}  and is_check != 1 order by id asc")
	List<Sample> getNoCheckList(Integer entrustId);

	@Select("select * from sample where entrust_id = #{entrustId}  and cement_code = #{cementCode}")
	List<Sample> getByCementCode(@Param("entrustId") Integer entrustId, @Param("cementCode") String  cementCode);


	@Select("select * from sample where entrust_id = #{entrustId} order by id asc")
	List<Sample> getSampleCheckList(Integer entrustId);
}
