package cn.wise.sc.cement.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 * @description: 委托方请求
 * @author: qh
 * @create: 2020-08-07 14:58
 **/
@Data
@RequiredArgsConstructor
@NoArgsConstructor
@ApiModel("委托单位请求")
public class ClientQuery {

    private Integer id;

    @ApiModelProperty(name = "name", value = "委托单位名")
    @NotEmpty(message = "委托单位不能为空!")
    @NonNull
    private String name;

    @ApiModelProperty(name = "principal", value = "委托单位联系人")
    @NotEmpty(message = "单位联系人不能为空!")
    @NonNull
    private String principal;

    @ApiModelProperty(name = "principalPhone", value = "委托单位联系人电话")
    @NotEmpty(message = "单位联系人电话不能为空!")
    @NonNull
    private String principalPhone;

    @ApiModelProperty(name = "region", value = "委托单位所在地区")
    @NotEmpty(message = "委托单位所在地区不能为空!")
    @NonNull
    private String region;
}
