package cn.wise.sc.cement.business.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@ApiModel("能力管理信息Vo")
public class CapabilityManagementVo {
    private Integer id;

    @ApiModelProperty("能力项")
    private String capabilityItem;

    @ApiModelProperty("能力范围")
    private String capabilityRange;

    @ApiModelProperty("取得日期")
    private LocalDate obtainTime;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    @ApiModelProperty("修改日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("用户表id")
    private Integer userId;
}
