package cn.wise.sc.cement.business.model.vo;

import cn.wise.sc.cement.business.model.query.EnclosureQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("设备检定Vo")
public class EquipmentTestVo {

	@ApiModelProperty("设备检定表id")
	private Integer id;

	@ApiModelProperty("设备名称")
	private String equipmentName;

	@ApiModelProperty("设备编号")
	private String code;

	@ApiModelProperty("设备品牌")
	private String brand;

	@ApiModelProperty("型号")
	private String model;

	@ApiModelProperty("检/校周期（年）")
	private Integer testCycle;

	@ApiModelProperty("检定日期")
	private LocalDate testDate;

	@ApiModelProperty("校验日期")
	private LocalDate checkDate;

	@ApiModelProperty("期间核查日期")
	private LocalDate periodDate;

	@ApiModelProperty("实施结果")
	private String tryResult;

	@ApiModelProperty("校核附件")
	private String enclosure;

	@ApiModelProperty("校核附件信息")
	private List<EnclosureQuery> enclosureQueryList;


}
