package cn.wise.sc.cement.business.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: wlb
 * @create: 2020-09-17
 **/
@Data
@ApiModel("历史档案Vo")
public class HistoryArchivesVo {
    private Integer id;

    @ApiModelProperty("日期")
    private LocalDate time;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    @ApiModelProperty("修改日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("用户id")
    private Integer userId;
}
