package cn.wise.sc.cement.business.model.vo;

import lombok.Data;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @description: 质量检测详情Vo
 * @author: qh
 * @create: 2020-09-28 14:55
 **/
@Data
public class QualityDetailVo implements Serializable {

    private static final long serialVersionUID = 42L;
    private String projectName;
    private String clientName;
    private String entrustCode;
    private Integer sampleNum;
    private String sendName;
    private String sendPhone;
    List<QualityTeamGroup> qualityTeamGroups = new ArrayList<>();


    @Data
    public static class QualityTeamGroup {
        private String teamGroupName;
        private List<QualitySample> qualitySamples = new ArrayList<>();
    }

    @Data
    public static class QualitySample {
        private String sampleName;
        private List<SampleOriginal> sampleOriginals = new ArrayList<>();
    }

    @Data
    public static class SampleOriginal {
        private String cementCode;
        private String userName;
        private String teamValues;
    }

}
