package cn.wise.sc.cement.business.model.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-27 14:58
 **/
@Data
@ApiModel("样品处理Vo")
public class SampleHandleVo {

	@ApiModelProperty("样品处理表id")
	private Integer id;

	@ApiModelProperty("项目id")
	private Integer projectId;

	@ApiModelProperty("项目名称")
	private String projectName;

	@ApiModelProperty("项目编号")
	private String projectCode;

	@ApiModelProperty("样品数量")
	private Integer sampleNum;

	@ApiModelProperty("样品表d")
	private Integer sampleId;

	@ApiModelProperty("样品名称")
	private String sampleName;

	@ApiModelProperty("来样编号")
	private String sampleCode;

	@ApiModelProperty("本所编号")
	private String cementCode;

	@ApiModelProperty("处理人员id")
	private Integer userId;

	@ApiModelProperty("处理人员姓名")
	private String userName;

	@ApiModelProperty("处理项（1、2、3）")
	private String content;

	@ApiModelProperty("处理项名称（打磨、棍磨）")
	private String contentName;

	@ApiModelProperty("要求完成日期(计划完成日期)")
	private LocalDate planFinishDate;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("（0未接受，1接受，2完成）")
	private Integer status;

	@ApiModelProperty(" 状态值（0未接受，1接受，2完成）")
	private String statusValue;

}
