package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 14:58
 **/
@Data
@ApiModel("样品管理Vo")
public class SampleManageVo {
	@ApiModelProperty("样品管理表id")
	private Integer id;

	@ApiModelProperty("样品表d")
	private Integer sampleId;

	@ApiModelProperty("样品名称")
	private String sampleName;

	@ApiModelProperty("来样编号（样品编号）")
	private String sampleCode;

	@ApiModelProperty("样品本所编号")
	private String cementCode;

	@ApiModelProperty("样品重量(kg)")
	private BigDecimal weight;

	@ApiModelProperty("处理人id")
	private Integer userId;

	@ApiModelProperty("项目id")
	private Integer projectId;

	@ApiModelProperty("项目名称")
	private String projectName;

	@ApiModelProperty("项目编号")
	private String projectCode;

	@ApiModelProperty("处理方式（0,取回，1由本所统一处置）")
	private Integer handleMethod;

	@ApiModelProperty("处理提醒时间")
	private LocalDate handleDate;

	@ApiModelProperty("小样位置")
	private String littlePosition;

	@ApiModelProperty("原样位置")
	private String originalPosition;

	@ApiModelProperty("（0未领用，1已领用，2已销毁）")
	private Integer status;

	@ApiModelProperty("样品登记时间")
	private LocalDateTime registerTime;

	@ApiModelProperty("销毁时间")
	private LocalDateTime destructionTime;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;




}
