package cn.wise.sc.cement.business.service.impl;



import cn.wise.sc.cement.business.entity.EntityEnclosure;
import cn.wise.sc.cement.business.entity.TeamGroup;
import cn.wise.sc.cement.business.mapper.EntityEnclosureMapper;
import cn.wise.sc.cement.business.mapper.TeamGroupMapper;
import cn.wise.sc.cement.business.mapper.TeamMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.query.EnclosureQuery;
import cn.wise.sc.cement.business.service.IEntityEnclosureService;
import cn.wise.sc.cement.business.util.CheckCountUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

@Service
public class CommonServiceImpl {

	@Resource
	private EntityEnclosureMapper entityEnclosureMapper;
	@Autowired
	private IEntityEnclosureService entityEnclosureService;
	@Resource
	private TeamMapper teamMapper;

	/**
	 * 生成编号
	 * @param prefix 编号前缀:  申请编号SQ
	 * @param counts 当天申请数量 生成的编号+1
	 * @return
	 */
	public String createNo(String prefix, int counts){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");//注意月份是MM
		String date = sdf.format(new Date());
		int nextNo = counts+1;
		String tailNo = counts==0?"00"+nextNo:(counts<10?"00"+nextNo:(counts<100?"0"+nextNo:String.valueOf(nextNo)));
		String applyNo = prefix+date+tailNo;
		return applyNo;
	}

	/**
	 * 生成平行样编号
	 * @param cementCode
	 * @return
	 */
	public String createParallelCode(String cementCode){
		String[] cementCodes = cementCode.split("-");
		Integer counts = Integer.parseInt(cementCodes[1])+1;
		String tailNo = counts<10?("000"+counts):
				counts<100?("00"+counts):
						counts<1000?("000"+counts):
								String.valueOf(counts);
		String resultCode = cementCodes[0]+"-"+tailNo;
		return resultCode;
	}

	/**
	 * 获取本所编号的Integer类型
	 * @param cementCode
	 * @return
	 */
	public Integer getIntegerCode(String cementCode){
		String[] cementCodes = cementCode.split("-");
		Integer counts = Integer.parseInt(cementCodes[1]);
		return counts;
	}

	/**
	 * 获取本所编号年份的Integer类型
	 * @param cementCode
	 * @return
	 */
	public String getIntegerYear(String cementCode){
		String[] cementCodes = cementCode.split("-");
		String counts = cementCodes[0];
		return counts;
	}

	/**
	 * Integer补0 转String
	 * @param counts
	 * @return
	 */
	public String getCementCode(Integer counts){
		String tailNo = counts<10?("000"+counts):
				counts<100?("00"+counts):
						counts<1000?("000"+counts):
								String.valueOf(counts);
		return tailNo;
	}


	/**
	 * 保存附件信息
	 * @param entityType  实体类型（0:用户(头像),1:合同附件,3设备校核附件，4标样材料）
	 * @param entityId    关联实体类id
	 * @param enclosureQueryList 上传的附件列表
	 */
	public Boolean saveEntityEnclosure(Integer entityType, Integer entityId, List<EnclosureQuery> enclosureQueryList ){
		Boolean ref = false;
		QueryWrapper<EntityEnclosure> wrapper = new QueryWrapper<>();
		wrapper.eq("entity_type", entityType);
		wrapper.eq("entity_id", entityId);
		List<EntityEnclosure> entityEnclosureList = entityEnclosureMapper.selectList(wrapper);
		if(entityEnclosureList != null && entityEnclosureList.size()>0){
			for(EntityEnclosure eeOld : entityEnclosureList){
				eeOld.setIsDeleted(0);
				entityEnclosureMapper.updateById(eeOld);
			}
		}
		if(enclosureQueryList != null && enclosureQueryList.size()>0){
			List<EntityEnclosure> eeList = new ArrayList<>();
			for(int i = 0; i < enclosureQueryList.size(); i++){
				EnclosureQuery enclosureDto = enclosureQueryList.get(i);
				EntityEnclosure ee = new EntityEnclosure();
				ee.setEntityId(entityId);
				ee.setEntityType(entityType);
				ee.setEnclosureUrl(enclosureDto.getEnclosureUrl());
				ee.setCreateTime(LocalDateTime.now());
				ee.setUpdateTime(ee.getCreateTime());
				ee.setIsDeleted(1);
				ee.setAlias(enclosureDto.getAlias());
				ee.setExtName(enclosureDto.getExtName());
				eeList.add(ee);
			}
			entityEnclosureService.saveBatch(eeList);
		}
		ref = true;
		return ref;
	}

	/**
	 * 根据实体类型 和实体类id获取附件列表
	 * @param entityType  实体类型（0:用户(头像),1:合同附件,3设备校核附件，4标样材料）
	 * @param entityId    关联实体类id
	 * @return
	 */
	public List<EntityEnclosure> getEnclosureList(Integer entityType,  Integer entityId){
		QueryWrapper<EntityEnclosure> wrapper = new QueryWrapper<>();
		wrapper.eq("entity_type", entityType);
		wrapper.eq("entity_id", entityId);
		List<EntityEnclosure> entityEnclosureList = entityEnclosureMapper.selectList(wrapper);
		return entityEnclosureList;
	}

	/**
	 *
	 * @param checkResutlList 检测组id集合
	 * @param resultMap 输入集合
	 * @return
	 */
	public Map<String, String> checkCount(List<String> checkResutlList, Map<String, Object> resultMap ){
//		List<String> checkResutlList = teamMapper.getByGroup(teamGroupId);
		//定义输出集合
		Map<String, String> countMap = new HashMap<>();
		//输出检测项第一次循环
		for(String name : checkResutlList){
			if(name.equals("L.O.I")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("SiO2")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Al2O3+TiO2")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Al2O3")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Fe2O3")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("CaO")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("MgO")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("TiO2")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("重量法_SO3")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("K2O")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Na2O")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("MnO")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Cl")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Mad1")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Mad2")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Aad1")){
				countMap.put(name,CheckCountUtil.checkCount(name,resultMap));
			}else if(name.equals("Aad2")) {
				countMap.put(name, CheckCountUtil.checkCount(name, resultMap));
			}else if(name.equals("焦渣")){
				countMap.put(name, CheckCountUtil.checkCount(name, resultMap));
			}else if(name.equals("St,ad")){
				countMap.put(name, CheckCountUtil.checkCount(name, resultMap));
			}else if(name.equals("易磨性等级")){
				countMap.put(name, CheckCountUtil.countYMXGrade(resultMap));
			}else if(name.equals("易磨性校验码")){
				countMap.put(name, CheckCountUtil.countYMXCode(resultMap));
			}

		}


		//输出检测项第二次循环
		for(String name : checkResutlList){
			if(name.equals("SO3")){
				String countSO3 = CheckCountUtil.countSO3(resultMap, countMap);
				countMap.put(name, countSO3);
			}else if(name.equals("KH")){
				String countKH = CheckCountUtil.countKH(countMap);
				countMap.put(name, countKH);
			}else if(name.equals("SM")){
				String countSM = CheckCountUtil.countSM(countMap);
				countMap.put(name, countSM);
			}else if(name.equals("AM")){
				String countAM = CheckCountUtil.countAM(countMap);
				countMap.put(name, countAM);
			}else if(name.equals("易烧性等级")){
				String burnupLevel = CheckCountUtil.countBurnupLevel(resultMap,countMap);
				countMap.put(name, burnupLevel);
			}else if(name.equals("报出_Mad")){
				String countBCMad = CheckCountUtil.countBCMad(countMap);
				countMap.put(name, countBCMad);
			}else if(name.equals("报出_Aad")){
				String countBCAad = CheckCountUtil.countBCAad(countMap);
				countMap.put(name, countBCAad);
			}

		}

		//输出检测项第三次循环
		for(String name : checkResutlList){
			if(name.equals("合量")){
				String countHL = CheckCountUtil.countHL(countMap);
				countMap.put(name, countHL);
			}else if(name.equals("Mad")){
				String countMad = CheckCountUtil.countMad(countMap);
				countMap.put(name, countMad);
			}else if(name.equals("Aad")){
				String countAad = CheckCountUtil.countAad(countMap);
				countMap.put(name, countAad);
			}else if(name.equals("Vad1")){
				String countVad1 = CheckCountUtil.countVad1(resultMap, countMap);
				countMap.put(name, countVad1);
			}else if(name.equals("Vad2")) {
				String countVad2 = CheckCountUtil.countVad2(resultMap, countMap);
				countMap.put(name, countVad2);
			}else if(name.equals("Mad判断")) {
				String countMadPD = CheckCountUtil.countMadPD(countMap);
				countMap.put(name, countMadPD);
			}else if(name.equals("Ad")) {
				String countAd = CheckCountUtil.countAd(countMap);
				countMap.put(name, countAd);
			}

		}

		//输出检测项第四次循环
		for(String name : checkResutlList){
			if(name.equals("报出_Vad")){
				String countBCVad = CheckCountUtil.countBCVad(countMap);
				countMap.put(name, countBCVad);
			}else if(name.equals("Ad系数0.1或0")) {
				String countAdXS = CheckCountUtil.countAdXS(countMap);
				countMap.put(name, countAdXS);
			}else if(name.equals("Vdaf系数0.8~0.95")) {
				String countVdafXS = CheckCountUtil.countVdafXS(countMap);
				countMap.put(name, countVdafXS);
			}

		}

		//输出检测项第五次循环
		for(String name : checkResutlList){
			if(name.equals("Vad")){
				String countVad = CheckCountUtil.countVad(countMap);
				countMap.put(name, countVad);
			}
		}

		//输出检测项第六次循环
		for(String name : checkResutlList){
			if(name.equals("Vdaf")){
				String countVdaf = CheckCountUtil.countVdaf(countMap);
				countMap.put(name, countVdaf);
			}
		}

		//输出检测项第七次循环
		for(String name : checkResutlList){
			if(name.equals("K1,")){
				String countK1_ = CheckCountUtil.countK1_(countMap);
				countMap.put(name, countK1_);
			}else if(name.equals("K")) {
				String countK = CheckCountUtil.countK(resultMap, countMap);
				countMap.put(name, countK);
			}else if(name.equals("Vdaf判断")) {
				String countVdafPD = CheckCountUtil.countVdafPD(countMap);
				countMap.put(name, countVdafPD);
			}else if(name.equals("V,daf")) {
				String countV_daf = CheckCountUtil.countV_daf(countMap);
				countMap.put(name, countV_daf);
			}

		}

		//输出检测项第八次循环
		for(String name : checkResutlList){
			if(name.equals("40Mad 0或1")){
				String count40Mad0Or1 = CheckCountUtil.count40Mad0Or1(countMap);
				countMap.put(name, count40Mad0Or1);
			}else if(name.equals("K0,")) {
				String countK0_ = CheckCountUtil.countK0_(countMap);
				countMap.put(name, countK0_);
			}
		}

		//输出检测项第九次循环
		for(String name : checkResutlList){
			if(name.equals("Qnet,ad MJ/kg")){
				String countQnet_adMJ_kg = CheckCountUtil.countQnet_adMJ_kg(resultMap, countMap);
				countMap.put(name, countQnet_adMJ_kg);
			}
		}






		return countMap;
	}


















}
