package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.NonStandardApply;
import cn.wise.sc.cement.business.entity.NonStandardApproval;
import cn.wise.sc.cement.business.mapper.NonStandardApplyMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.NonStandardApplyQuery;
import cn.wise.sc.cement.business.model.vo.NonStandardApplyVo;
import cn.wise.sc.cement.business.model.vo.NonStandardValueVo;
import cn.wise.sc.cement.business.service.INonStandardApplyService;
import cn.wise.sc.cement.business.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.swagger.models.auth.In;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.swing.text.ParagraphView;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author wlb
 * @since 2020-09-23
 */
@Service
public class NonStandardApplyServiceImpl extends ServiceImpl<NonStandardApplyMapper, NonStandardApply> implements INonStandardApplyService {
	@Resource
	private NonStandardApplyMapper nonStandardApplyMapper;

	@Override
		public BaseResponse<IPage<NonStandardApplyVo>> getPage (PageQuery pageQuery,String name){
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		Page<NonStandardApplyVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<NonStandardApplyVo> pages = nonStandardApplyMapper.getPage(page,params);
		return BaseResponse.okData(pages);
	}

	@Override
	public BaseResponse<List<NonStandardApplyVo>> getList() {
		QueryWrapper<NonStandardApply> qw = new QueryWrapper<>();
		qw.ge("status",0);
		List<NonStandardApplyVo> list = nonStandardApplyMapper.getList(qw);
		return BaseResponse.okData(list);
	}

	@Override
	public BaseResponse<List<NonStandardApplyVo>> getById(Integer id) {
		Map<String, Object> params = new HashMap<>();
		params.put("id",id);
		List<NonStandardApplyVo> list= nonStandardApplyMapper.getById(params);
		return BaseResponse.okData(list);
	}

	@Override
	@Transactional
	public BaseResponse<NonStandardApply> create(NonStandardApplyQuery query) {
		NonStandardApply cama = new NonStandardApply();
		BeanUtils.copyProperties(query, cama);
		cama.setStatistical(cama.getStartTime() + "/" + cama.getEndTime());
		nonStandardApplyMapper.insert(cama);
		return BaseResponse.okData(cama);
	}

	@Override
	public BaseResponse<NonStandardApply> update(NonStandardApplyQuery query) {
		NonStandardApply nsa = new NonStandardApply();
		BeanUtils.copyProperties(query, nsa);
		nsa.setId(query.getId());
		nonStandardApplyMapper.updateById(nsa);
		return BaseResponse.okData(nsa);
	}

	@Override
	public BaseResponse delete(Integer id) {
		NonStandardApply nsa = nonStandardApplyMapper.selectById(id);
		if(nsa == null){
			return BaseResponse.errorMsg("检测依据不存在");
		}
		nonStandardApplyMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}

	@Override
	@Transactional
	public BaseResponse<String> status(Integer status, Integer id) {
		if(status == null || id == null){
			return BaseResponse.errorMsg("参数错误!");
		}
		NonStandardApply nonStandardApply = nonStandardApplyMapper.selectById(id);
		if(nonStandardApply == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		nonStandardApply.setStatus(status);
		nonStandardApplyMapper.updateById(nonStandardApply);
		String result = "";
		if(nonStandardApply.getStatus() == 1){
			result = "已提交";
		}else{
			result = "未提交";
		}
		return BaseResponse.okData(result);
	}

	@Override
	public void exportList(String filename, Integer userId, String name, HttpServletResponse response) {
		Map<String, Object> params = new HashMap<>();
		params.put("userId", userId);
		params.put("name", name);
		List<Map<String, Object>> list= nonStandardApplyMapper.exportList(params);

		if (!CollectionUtils.isEmpty(list)) {
			Map<String,Object> map=list.get(0);
			String[] headers = new String[map.size()];
			headers[0] = "序号";
			headers[1] = "姓名";
			headers[2] = "账户";
			headers[3] = "起止日期";
			headers[4] = "上报工时";
			headers[5] = "状态";
			headers[6] = "工作类别";
			headers[7] = "工作描述";

			List<Object[]> datas = new ArrayList<>(list.size());
			for (Map<String, Object> m : list) {
				Object[] objects = new Object[headers.length];
				for (int j = 0; j < headers.length; j++) {
					String obj = m.get(headers[j]).toString();
					if(j==0){
						obj = obj.split("\\.")[0];
					}
					objects[j] = obj;
				}

				datas.add(objects);
			}
			ExcelUtil.excelExport(
					filename == null || filename.trim().length() <= 0 ? "非标产值申请": filename, headers,
					datas, response);
		}
	}

}
