package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.PlanConsumablesPurchase;
import cn.wise.sc.cement.business.entity.PlanEquipmentPurchase;
import cn.wise.sc.cement.business.mapper.PlanConsumablesPurchaseMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanConsumablesPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.vo.PlanConsumablesPurchaseVo;
import cn.wise.sc.cement.business.model.vo.PlanEquipmentPurchaseVo;
import cn.wise.sc.cement.business.service.IPlanConsumablesPurchaseService;
import cn.wise.sc.cement.business.service.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Service
public class PlanConsumablesPurchaseServiceImpl extends ServiceImpl<PlanConsumablesPurchaseMapper, PlanConsumablesPurchase> implements IPlanConsumablesPurchaseService {

	@Resource
	private PlanConsumablesPurchaseMapper consumablesPurchaseMapper;
	@Autowired
	private ISysUserService userService;

	/**
	 * 分页查询
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<PlanConsumablesPurchaseVo>> getPage(PageQuery pageQuery, String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		Page<PlanConsumablesPurchaseVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<PlanConsumablesPurchaseVo> pages = consumablesPurchaseMapper.getPage(page,params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 创建
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanConsumablesPurchase> create(PlanConsumablesPurchaseQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if(loginUser == null){
			return BaseResponse.errorMsg("请登录用户");
		}
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanConsumablesPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = consumablesPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanConsumablesPurchase pep = new PlanConsumablesPurchase();
		BeanUtils.copyProperties(query,pep);
		pep.setUserId(loginUser.getId())
				.setStatus(0)
				.setCreateTime(LocalDateTime.now());
		consumablesPurchaseMapper.insert(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 修改
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanConsumablesPurchase> update(PlanConsumablesPurchaseQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanConsumablesPurchase> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = consumablesPurchaseMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanConsumablesPurchase pep = consumablesPurchaseMapper.selectById(query.getId());
		BeanUtils.copyProperties(query, pep);
		consumablesPurchaseMapper.updateById(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 获取详情
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<PlanConsumablesPurchaseVo> getDetail(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanConsumablesPurchase pep = consumablesPurchaseMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("信息错误!");
		}
		PlanConsumablesPurchaseVo planEquipmentPurchaseVo = consumablesPurchaseMapper.getDetail(id);
		return BaseResponse.okData(planEquipmentPurchaseVo);
	}

	/**
	 * 采购完成
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> finish(Integer id) {
		if( id == null){
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanConsumablesPurchase pep = consumablesPurchaseMapper.selectById(id);
		if(pep == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		pep.setStatus(1); //采购完成
		consumablesPurchaseMapper.updateById(pep);
		return BaseResponse.okData("采购完成");
	}

	/**
	 * 删除
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<String> delete(Integer id) {
		PlanConsumablesPurchase pep = consumablesPurchaseMapper.selectById(id);
		if(pep == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		consumablesPurchaseMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}


}
