package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.PlanEquipmentPurchase;
import cn.wise.sc.cement.business.entity.PlanEquipmentRepair;
import cn.wise.sc.cement.business.mapper.PlanEquipmentRepairMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.LoginUser;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentPurchaseQuery;
import cn.wise.sc.cement.business.model.query.PlanEquipmentRepairQuery;
import cn.wise.sc.cement.business.model.vo.PlanEquipmentPurchaseVo;
import cn.wise.sc.cement.business.model.vo.PlanEquipmentRepairVo;
import cn.wise.sc.cement.business.service.IPlanEquipmentRepairService;
import cn.wise.sc.cement.business.service.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Service
public class PlanEquipmentRepairServiceImpl extends ServiceImpl<PlanEquipmentRepairMapper, PlanEquipmentRepair> implements IPlanEquipmentRepairService {

	@Resource
	private PlanEquipmentRepairMapper equipmentRepairMapper;
	@Autowired
	private ISysUserService userService;

	/**
	 * 分页查询
	 * @param pageQuery
	 * @param name
	 * @return
	 */
	@Override
	public BaseResponse<IPage<PlanEquipmentRepairVo>> getPage(PageQuery pageQuery, String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("name", name);
		Page<PlanEquipmentRepairVo> page = new Page<>(pageQuery.getPageNo(), pageQuery.getPageSize());
		IPage<PlanEquipmentRepairVo> pages = equipmentRepairMapper.getPage(page,params);
		return BaseResponse.okData(pages);
	}

	/**
	 * 创建
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanEquipmentRepair> create(PlanEquipmentRepairQuery query) {
		LoginUser loginUser = userService.getLoginUser();
		if(loginUser == null){
			return BaseResponse.errorMsg("请登录用户");
		}
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanEquipmentRepair> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		int count = equipmentRepairMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanEquipmentRepair pep = new PlanEquipmentRepair();
		BeanUtils.copyProperties(query,pep);
		pep.setUserId(loginUser.getId())
				.setStatus(0)
				.setCreateTime(LocalDateTime.now());
		equipmentRepairMapper.insert(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 修改
	 * @param query
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<PlanEquipmentRepair> update(PlanEquipmentRepairQuery query) {
		if (StringUtils.isEmpty(query.getName())) {
			return BaseResponse.errorMsg("产品名称不能为空!");
		}
		QueryWrapper<PlanEquipmentRepair> qw = new QueryWrapper<>();
		qw.eq("name", query.getName());
		qw.ne("id", query.getId());
		int count = equipmentRepairMapper.selectCount(qw);
		if (count > 0) {
			return BaseResponse.errorMsg(query.getName() + "已存在");
		}
		PlanEquipmentRepair pep = equipmentRepairMapper.selectById(query.getId());
		BeanUtils.copyProperties(query, pep);
		equipmentRepairMapper.updateById(pep);
		return BaseResponse.okData(pep);
	}

	/**
	 * 获取详情
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<PlanEquipmentRepairVo> getDetail(Integer id) {
		if (id == null) {
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanEquipmentRepair pep = equipmentRepairMapper.selectById(id);
		if (pep == null) {
			return BaseResponse.errorMsg("信息错误!");
		}
		PlanEquipmentRepairVo planEquipmentPurchaseVo = equipmentRepairMapper.getDetail(id);
		return BaseResponse.okData(planEquipmentPurchaseVo);
	}

	/**
	 * 维修完成
	 * @param id
	 * @return
	 */
	@Transactional
	@Override
	public BaseResponse<String> finish(Integer id) {
		if( id == null){
			return BaseResponse.errorMsg("参数错误!");
		}
		PlanEquipmentRepair pep = equipmentRepairMapper.selectById(id);
		if(pep == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		pep.setStatus(1); //维修完成
		equipmentRepairMapper.updateById(pep);
		return BaseResponse.okData("维修完成");
	}

	/**
	 * 删除
	 * @param id
	 * @return
	 */
	@Override
	public BaseResponse<String> delete(Integer id) {
		PlanEquipmentRepair pep = equipmentRepairMapper.selectById(id);
		if(pep == null){
			return BaseResponse.errorMsg("数据错误!");
		}
		equipmentRepairMapper.deleteById(id);
		return BaseResponse.okData("删除成功");
	}




}
