package cn.wise.sc.cement.business.service.impl;

import cn.wise.sc.cement.business.entity.SysDictionary;
import cn.wise.sc.cement.business.mapper.SysDictionaryMapper;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.service.ISysDictionaryService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mysql.cj.xdevapi.JsonArray;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ztw
 * @since 2020-09-12
 */
@Service
public class SysDictionaryServiceImpl extends ServiceImpl<SysDictionaryMapper, SysDictionary> implements ISysDictionaryService {

	@Resource
	private SysDictionaryMapper dictionaryMapper;


	@Override
	public BaseResponse<JSONArray> getContent(String name){
		QueryWrapper<SysDictionary> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("name", name);
		SysDictionary  dictionary = dictionaryMapper.selectOne(queryWrapper);
		if(dictionary == null){
			return BaseResponse.errorMsg("信息错误");
		}
		String coneten = dictionary.getContent();

		JSONArray jsonArray= JSONArray.parseArray(coneten);
		return BaseResponse.okData(jsonArray);
	}


}
