package cn.wise.sc.cement.business.controller;

import cn.wise.sc.cement.business.entity.CapabilityManagement;
import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.CapabilityManagementQuery;
import cn.wise.sc.cement.business.service.ICapabilityManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author wlb
 * @since 2020-09-17
 */
@Api(tags = "人员详情-能力管理")
@RestController
@RequestMapping("/tcdri/capability_management")
public class CapabilityManagementController {
    private static final Logger log = LoggerFactory.getLogger("CapabilityManagementController");

    @Autowired
    private ICapabilityManagementService capabilityManagementService;

    @ApiOperation(value = "能力管理分页，可通过用户id查询能力信息")
    @GetMapping("/getPage")
    public BaseResponse getPage(PageQuery pageQuery,Integer userId) {
        try {
            return capabilityManagementService.getPage(pageQuery, userId);
        } catch (Exception e) {
            log.debug("能力信息管理分页列表{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "根据默认ID查找能力信息")
    @GetMapping("/{id}")
    public BaseResponse getById(@PathVariable Integer id){
        try {
            CapabilityManagement e = capabilityManagementService.getById(id);
            if(e == null){
                return BaseResponse.errorMsg("信息错误!");
            }
            return BaseResponse.okData(e);
        }catch (Exception e){
            log.debug("能力管理详情{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }


    @ApiOperation(value = "获取所有能力信息")
    @GetMapping("/getList")
    public BaseResponse getList() {
        try {
            return capabilityManagementService.getList();
        } catch (Exception e) {
            log.debug("获取所有的能力管理信息{}", e);
        }
        return BaseResponse.errorMsg("失败!");
    }


    @ApiOperation(value = "新增能力管理信息")
    @PostMapping("/create")
    public BaseResponse create(@RequestBody CapabilityManagementQuery query){
        try {
            return capabilityManagementService.create(query);
        }catch (Exception e){
            log.debug("新增能力管理信息{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "更新能力管理信息")
    @PostMapping("/update")
    public BaseResponse update(@RequestBody CapabilityManagementQuery capabilityManagementQuery){
        try {
            return capabilityManagementService.update(capabilityManagementQuery);
        }catch (Exception e){
            log.debug("更新能力管理信息{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

    @ApiOperation(value = "删除能力管理信息")
    @PostMapping("/delete/{id}")
    public BaseResponse delete(@PathVariable Integer id){
        try {
            return capabilityManagementService.delete(id);
        }catch (Exception e){
            log.debug("删除能力管理信息{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }

  /*  @ApiOperation(value = "根据用户id查询数据")
    @PostMapping("/delete")
    public BaseResponse delete(@RequestBody Integer id){
        try {
            return capabilityManagementService.delete(id);
        }catch (Exception e){
            log.debug("删除能力管理信息{}",e);
        }
        return BaseResponse.errorMsg("失败!");
    }*/
}
