package cn.wise.sc.cement.business.controller;


import cn.wise.sc.cement.business.model.BaseResponse;
import cn.wise.sc.cement.business.model.PageQuery;
import cn.wise.sc.cement.business.model.query.SampleManageQuery;
import cn.wise.sc.cement.business.model.query.StandardQuery;
import cn.wise.sc.cement.business.service.ISampleService;
import cn.wise.sc.cement.business.service.ISysDictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2020-09-04
 */
@Api(tags="样品管理")
@RestController
@RequestMapping("/business/sample")
public class SampleController {

	private static final Logger log = LoggerFactory.getLogger("SampleController");

	@Autowired
	private ISampleService sampleService;
	@Autowired
	private ISysDictionaryService dictionaryService;

	@ApiOperation(value = "样品分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "sampleName", value = "样品名称", paramType = "query", dataType = "String"),
			@ApiImplicitParam(name = "cementCode", value = "样品本所编号", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public BaseResponse getPage(PageQuery pageQuery, String sampleName, String cementCode) {
		try {
			return sampleService.getPage(pageQuery, sampleName, cementCode);
		} catch (Exception e) {
			log.debug("样品分页列表{}", e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation("样品列表导出")
	@PostMapping("/export")
	public void export(String sampleName, String cementCode,
	                   String fileName, HttpServletResponse response) {
		try {
			sampleService.export(sampleName, cementCode,
					 fileName, response);
		} catch (Exception e) {
			log.debug("样品列表导出{}", e);
		}
	}




	@ApiOperation(value = "样品详情")
	@GetMapping("/{id}")
	public BaseResponse getById(@PathVariable Integer id){
		try {
			return sampleService.getDetail(id);
		}catch (Exception e){
			log.debug("样品详情{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "样品登记")
	@PostMapping("/register")
	public BaseResponse register(@RequestBody SampleManageQuery query) {
		try {
			return sampleService.register(query);
		}catch (Exception e) {
			log.debug("样品登记{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "样品销毁")
	@PostMapping("/destruction/{id}")
	public BaseResponse destruction(@PathVariable Integer id) {
		try {
			return sampleService.destruction(id);
		}catch (Exception e) {
			log.debug("样品销毁{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}

	@ApiOperation(value = "获取样品状态列表")
	@GetMapping("/getSampleFormList")
	public BaseResponse getSampleFormList(){
		try {
			return dictionaryService.getContent("样品状态");
		}catch (Exception e){
			log.debug("获取样品状态列表{}",e);
		}
		return BaseResponse.errorMsg("失败!");
	}



}

