package cn.wise.sc.cement.business.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-09-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EquipmentUse implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("设备表id")
    private Integer equipmentId;

    @ApiModelProperty("使用人id")
    private Integer userId;

    @ApiModelProperty("使用人姓名")
    private String userName;

    @ApiModelProperty("使用日期")
    private LocalDate useDate;

    @ApiModelProperty("项目id")
    private Integer projectId;

	@ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目编号")
    private String projectCode;

    @ApiModelProperty("检测项id（检测项表id）")
    private Integer testItemId;

    @ApiModelProperty("检测项名称")
    private String testItem;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;


}
