package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 非标产值申请
 * </p>
 *
 * @author wlb
 * @since 2020-09-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName(value = "nonstandard_apply")
public class NonStandardApply implements Serializable {

	private static final long serialVersionUID = 1L;

	/*
	主键
	 */
	@TableId(value = "id",type = IdType.AUTO)
	private Integer id;

	@ApiModelProperty("起止日期")
	private String statistical;

	@ApiModelProperty("上报工时")
	private Double reportedHours;

	@ApiModelProperty("状态 0：未提交 1：待审批 2：已通过 3:未通过")
	private Integer status;

	@ApiModelProperty("工作类别")
	private String workType;

	@ApiModelProperty("开始时间")
	private LocalDate startTime;

	@ApiModelProperty("结束时间")
	private LocalDate endTime;

	@ApiModelProperty("工作描述")
	private String workDescription;

	@ApiModelProperty("用户id")
	private Integer userId;
}
