package cn.wise.sc.cement.business.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-09-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PlanEquipmentRepair implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
      @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("产品名称")
    private String name;

    @ApiModelProperty("规格型号")
    private String model;

    @ApiModelProperty("技术指标")
    private String technicalIndex;

    @ApiModelProperty("单价（万元）")
    private BigDecimal unitPrice;

    @ApiModelProperty("生产单位")
    private String productionUnit;

    @ApiModelProperty("维修日期")
    private LocalDate repairDate;

    @ApiModelProperty("创建人id")
    private Integer userId;

    @ApiModelProperty("维修人id")
    private Integer repairerId;

    @ApiModelProperty("状态（0待完成，1已完成）")
    private Integer status;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

}
