package cn.wise.sc.cement.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2020-08-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SysUser implements Serializable {

    private static final long serialVersionUID=1L;

      @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("真实姓名")
    private String name;

    @ApiModelProperty("性别0女1男")
    private Integer sex;

    @ApiModelProperty("部门id")
    private Integer groupId;

    @ApiModelProperty("职务id")
    private Integer postId;

    @ApiModelProperty("微信号")
    private String wxId;

    @ApiModelProperty("职称")
    private String qualifications;

    @ApiModelProperty("状态（0禁用，1启用")
    private Integer status;

    @ApiModelProperty("工作年限")
    private Double workYear;

    @ApiModelProperty("手机号")
    private String phone;

	@ApiModelProperty("传真")
	private String fax;

    @ApiModelProperty("专业")
    private String major;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("从事本技术领域日期")
    private LocalDate technologyDate;

    @ApiModelProperty("从事本技术领域年限")
    private Double technologyYear;

    @ApiModelProperty("文化程度")
    private String education;

    @ApiModelProperty("（0删除，1正常）")
    private Integer isDelete;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    private LocalDateTime updateTime;

    @ApiModelProperty("备注")
    private String remark;


}
