package cn.wise.sc.cement.business.enumation;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author neo.shu
 * @since 2020/4/22 17:40
 */
@JSONType(serializeEnumAsJavaBean = true)
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@AllArgsConstructor
@Getter
public enum ProjectRole {

    PM("PM","项目经理", true),
    PD("PD","产品设计", false),
    UD("UD","UI设计", false),
    FD("FD","前端开发", false),
    BD("BD","后端开发", false),
    TD("TD","测试经理", false),
    QA("QA","质量管理", true),
    ;
    @EnumValue
    private String dbName;
    private String label;
    private boolean isManage;

    public int getValue() {
        return this.ordinal();
    }
}
