package cn.wise.sc.cement.business.model;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

/**
 * @description: 分页条件查询 mybatis解析
 * @author: qh
 * @create: 2020-01-08 22:11
 **/
public class PageWrapperQueryMyBatisResolver {

    public static WrapperQuery create() {
        return new WrapperQuery();
    }

    /**
     * 组装查询条件
     *
     * @param query
     * @return
     */
    public static  QueryWrapper getQueryWrapper(WrapperQuery query) {

        QueryWrapper queryWrapper = Wrappers.query();

        //拼装等于条件
        if (query.getEq() != null) {
            for (String key : query.getEq().keySet()) {
                queryWrapper.eq(key, query.getEq().get(key));
            }
        }
        //拼装小于条件
        if (query.getLt() != null) {
            for (String key : query.getLt().keySet()) {
                queryWrapper.lt(key, query.getLt().get(key));
            }
        }

        //拼装小于等于条件
        if (query.getLe() != null) {
            for (String key : query.getLe().keySet()) {
                queryWrapper.le(key, query.getLe().get(key));
            }
        }
        //拼装大于于条件
        if (query.getGt() != null) {
            for (String key : query.getGt().keySet()) {
                queryWrapper.gt(key, query.getGt().get(key));
            }
        }

        //拼装大于等于条件
        if (query.getGe() != null) {
            for (String key : query.getGe().keySet()) {
                queryWrapper.ge(key, query.getGe().get(key));
            }
        }
        //in条件
        if (query.getIn() != null) {
            for (String key : query.getIn().keySet()) {
                queryWrapper.in(key, query.getIn().get(key));
            }
        }
        //拼装like条件
        if (query.getLike() != null) {
            for (String key : query.getLike().keySet()) {
                queryWrapper.like(key, query.getLike().get(key));
            }
        }
        if (query.getOr() != null) {
            for (String key : query.getOr().keySet()) {
                queryWrapper.or(true).eq(key, query.getLike().get(key));
            }
        }
        if (StrUtil.isNotEmpty(query.getSql())) {
            queryWrapper.last(query.getSql());
        }
        return queryWrapper;
    }

}
