package cn.wise.sc.cement.business.model;

import lombok.Data;

import java.io.Serializable;

/**
 * @description: 六元素检测报告
 * @author: qh
 * @create: 2020-10-15 12:24
 **/
@Data
public class SixElementReport implements Serializable {

    private static final long serialVersionUID = 42L;

    /**
     * 样品名称
     */
    private String sampleName;

    /**
     * 来样状态
     */
    private String sampleForm;

    /**
     * 来样编号
     */
    private String sampleCode;

    /**
     * 样品重量
     */
    private String weight;

    /**
     * 本所编号
     */
    private String cementCode;

    /**
     * 校核数据
     */
    private String countResult;

    //下面为六元素

    private String loi ="";
    private String sio2 ="";
    private String fe2o3 ="";
    private String cao ="";
    private String mgo ="";
    private String so3 ="";
    private String cl="";

    //情况一:Al2O3(含TiO3)

    private String al2o3AndTio2 ="";

    //情况二:Al2O3和TiO3单独分开

    private String al2o3 ="";
    private String tio2 ="";
}
