package cn.wise.sc.cement.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2020-08-07 15:09
 **/

@Data
@ApiModel("消耗品采购计划Vo")
public class PlanConsumablesPurchaseVo {

	@ApiModelProperty("消耗品采购计划表id")
	private Integer id;

	@ApiModelProperty("产品名称")
	private String name;

	@ApiModelProperty("规格型号")
	private String model;

	@ApiModelProperty("技术指标")
	private String technicalIndex;

	@ApiModelProperty("单价（万元）")
	private BigDecimal unitPrice;

	@ApiModelProperty("生产单位")
	private String productionUnit;

	@ApiModelProperty("采购数量")
	private Integer purchaseNum;

	@ApiModelProperty("采购日期（购买日期）")
	private LocalDate purchaseDate;

	@ApiModelProperty("采购人id")
	private Integer purchaserId;

	@ApiModelProperty("采购人姓名")
	private String purchaserName;

	@ApiModelProperty("创建人id")
	private Integer userId;

	@ApiModelProperty("创建人姓名")
	private String userName;

	@ApiModelProperty("状态（0禁用，1已启用）")
	private Integer status;

	@ApiModelProperty("创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty("备注")
	private String remark;


}
